/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.proxies;

import ftbsc.lll.proxies.ProxyType;
import ftbsc.lll.proxies.QualifiableProxy;
import org.objectweb.asm.Type;

public abstract class AbstractProxy {
    public final ProxyType proxyType;
    public final String name;
    public final String descriptor;
    public final QualifiableProxy parent;
    public final int modifiers;

    protected AbstractProxy(String name, String descriptor, int modifiers, QualifiableProxy parent, ProxyType proxyType) {
        this.name = name;
        this.descriptor = descriptor;
        this.modifiers = modifiers;
        this.parent = parent;
        this.proxyType = proxyType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractProxy) {
            AbstractProxy p = (AbstractProxy)obj;
            return p.parent.equals(this.parent) && p.name.equals(this.name) && p.modifiers == this.modifiers && p.descriptor.equals(this.descriptor);
        }
        return false;
    }

    public static abstract class Builder<T extends AbstractProxy> {
        protected String name;
        protected int modifiers;
        protected QualifiableProxy parent;
        protected String descriptor;

        protected Builder(String name) {
            this.name = name;
            this.modifiers = 0;
        }

        public Builder<T> addModifier(int newModifier) {
            this.modifiers |= newModifier;
            return this;
        }

        public Builder<T> setModifiers(int newModifier) {
            this.modifiers = newModifier;
            return this;
        }

        public Builder<T> setParent(QualifiableProxy parent) {
            this.parent = parent;
            return this;
        }

        public Builder<T> setDescriptor(String descriptor) {
            this.descriptor = descriptor;
            return this;
        }

        public Builder<T> setType(Type type) {
            return this.setDescriptor(type.getDescriptor());
        }

        public abstract T build();
    }
}

