/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.proxies;

import ftbsc.lll.proxies.AbstractProxy;
import ftbsc.lll.proxies.ProxyType;

public abstract class QualifiableProxy
extends AbstractProxy {
    public final String fullyQualifiedName;
    public final String internalName;

    protected QualifiableProxy(String descriptor, int modifiers, QualifiableProxy parent, String fullyQualifiedName, ProxyType proxyType) {
        super(QualifiableProxy.extractSimpleNameFromFQN(fullyQualifiedName), descriptor, modifiers, parent, proxyType);
        this.fullyQualifiedName = fullyQualifiedName;
        this.internalName = this.fullyQualifiedName.replace('.', '/');
    }

    protected static String extractParentFromFQN(String fqn) {
        String lastSeparator = fqn.contains("$") ? "$" : ".";
        int pos = fqn.lastIndexOf(lastSeparator);
        if (pos == -1) {
            return null;
        }
        return fqn.substring(0, pos);
    }

    protected static String extractSimpleNameFromFQN(String fqn) {
        String lastSeparator = fqn.contains("$") ? "\\$" : "\\.";
        String[] split = fqn.split(lastSeparator);
        if (split.length == 1) {
            return fqn;
        }
        return split[split.length - 1];
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof QualifiableProxy && super.equals(obj) && ((QualifiableProxy)obj).fullyQualifiedName.equals(this.fullyQualifiedName);
    }
}

