/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.proxies.impl;

import ftbsc.lll.proxies.AbstractProxy;
import ftbsc.lll.proxies.ProxyType;
import ftbsc.lll.proxies.QualifiableProxy;
import ftbsc.lll.proxies.impl.TypeProxy;
import ftbsc.lll.utils.DescriptorBuilder;
import java.lang.reflect.Field;
import org.objectweb.asm.Type;

public class FieldProxy
extends AbstractProxy {
    protected FieldProxy(String name, String descriptor, int modifiers, QualifiableProxy parent) {
        super(name, descriptor, modifiers, parent, ProxyType.FIELD);
    }

    public FieldProxy(Field f) {
        this(f.getName(), Type.getDescriptor(f.getType()), f.getModifiers(), TypeProxy.from(f.getDeclaringClass()));
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FieldProxy && super.equals(obj);
    }

    public static class Builder
    extends AbstractProxy.Builder<FieldProxy> {
        Builder(String name) {
            super(name);
        }

        public Builder setParent(String parentFQN, int modifiers) {
            super.setParent(TypeProxy.from(parentFQN, 0, modifiers));
            return this;
        }

        public Builder setParent(String parentFQN) {
            return this.setParent(parentFQN, 0);
        }

        public Builder setType(Class<?> clazz) {
            super.setType(Type.getType(clazz));
            return this;
        }

        public Builder setType(String fqn, int arrayLevel) {
            super.setType(Type.getType((String)DescriptorBuilder.nameToDescriptor(fqn, arrayLevel)));
            return this;
        }

        @Override
        public FieldProxy build() {
            return new FieldProxy(this.name, this.descriptor, this.modifiers, this.parent);
        }
    }
}

