/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.proxies.impl;

import ftbsc.lll.proxies.AbstractProxy;
import ftbsc.lll.proxies.ProxyType;
import ftbsc.lll.proxies.QualifiableProxy;
import ftbsc.lll.proxies.impl.TypeProxy;
import ftbsc.lll.utils.DescriptorBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;

public class MethodProxy
extends AbstractProxy {
    public final TypeProxy[] parameters;
    public final TypeProxy returnType;

    protected MethodProxy(String name, int modifiers, QualifiableProxy parent, Type[] parameters, Type returnType) {
        super(name, Type.getMethodDescriptor((Type)returnType, (Type[])parameters), modifiers, parent, ProxyType.METHOD);
        this.parameters = (TypeProxy[])Arrays.stream(parameters).map(t -> TypeProxy.from(t, 0)).toArray(TypeProxy[]::new);
        this.returnType = TypeProxy.from(returnType, 0);
    }

    public MethodProxy(Method m) {
        this(m.getName(), m.getModifiers(), TypeProxy.from(m.getDeclaringClass()), Type.getArgumentTypes((Method)m), Type.getReturnType((Method)m));
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MethodProxy) {
            MethodProxy m = (MethodProxy)obj;
            return super.equals(obj) && m.returnType.equals(this.returnType) && Arrays.equals(m.parameters, this.parameters);
        }
        return false;
    }

    public static class Builder
    extends AbstractProxy.Builder<MethodProxy> {
        private final List<Type> parameters = new ArrayList<Type>();
        private Type returnType = Type.getType(Void.TYPE);

        Builder(String name) {
            super(name);
        }

        public Builder addParameter(String fqn, int arrayLevel) {
            this.parameters.add(Type.getType((String)DescriptorBuilder.nameToDescriptor(fqn, arrayLevel)));
            return this;
        }

        public Builder addParameter(Class<?> paramType) {
            this.parameters.add(Type.getType(paramType));
            return this;
        }

        public Builder setReturnType(String fqn, int arrayLevel) {
            this.returnType = Type.getType((String)DescriptorBuilder.nameToDescriptor(fqn, arrayLevel));
            return this;
        }

        public Builder setParent(String parentFQN, int modifiers) {
            super.setParent(TypeProxy.from(parentFQN, 0, modifiers));
            return this;
        }

        public Builder setParent(String parentFQN) {
            return this.setParent(parentFQN, 0);
        }

        public Builder setReturnType(Class<?> returnType) {
            this.returnType = Type.getType(returnType);
            return this;
        }

        public Builder setDescriptor(String descr) {
            super.setDescriptor(descr);
            this.parameters.addAll(Arrays.asList(Type.getArgumentTypes((String)descr)));
            this.returnType = Type.getReturnType((String)descr);
            return this;
        }

        @Override
        public MethodProxy build() {
            return new MethodProxy(this.name, this.modifiers, this.parent, this.parameters.toArray(new Type[0]), this.returnType);
        }
    }
}

