/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.proxies.impl;

import ftbsc.lll.proxies.ProxyType;
import ftbsc.lll.proxies.QualifiableProxy;
import ftbsc.lll.proxies.impl.PackageProxy;
import ftbsc.lll.utils.DescriptorBuilder;
import org.objectweb.asm.Type;

public class TypeProxy
extends QualifiableProxy {
    public final boolean primitive;

    protected TypeProxy(String name, String descriptor, int modifiers, String parent, boolean primitive) {
        super(descriptor, modifiers, PackageProxy.from(parent), parent == null ? name : String.format("%s.%s", parent, name), ProxyType.TYPE);
        this.primitive = primitive;
    }

    protected TypeProxy(String name, String descriptor, int modifiers, TypeProxy containerClass, boolean primitive) {
        super(descriptor, modifiers, containerClass, String.format("%s$%s", containerClass.fullyQualifiedName, name), ProxyType.TYPE);
        this.primitive = primitive;
    }

    public static TypeProxy from(Type type, int modifiers) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        boolean primitive = type.getSort() < 9;
        String fqn = primitive ? type.getClassName() : type.getInternalName().replace('/', '.');
        String simpleName = TypeProxy.extractSimpleNameFromFQN(fqn);
        String parent = TypeProxy.extractParentFromFQN(fqn);
        if (fqn.contains("$") && parent != null) {
            return new TypeProxy(simpleName, type.getDescriptor(), modifiers, TypeProxy.from(parent, 0, 1), primitive);
        }
        return new TypeProxy(simpleName, type.getDescriptor(), modifiers, parent, primitive);
    }

    public static TypeProxy from(String fqn, int arrayLevel, int modifiers) {
        return TypeProxy.from(Type.getType((String)DescriptorBuilder.nameToDescriptor(fqn, arrayLevel)), modifiers);
    }

    public static TypeProxy from(Class<?> clazz) {
        Class<?> parentClass = clazz.getEnclosingClass();
        if (parentClass == null) {
            return new TypeProxy(clazz.getSimpleName(), Type.getDescriptor(clazz), clazz.getModifiers(), clazz.getPackage().getName(), clazz.isPrimitive());
        }
        return new TypeProxy(clazz.getSimpleName(), Type.getDescriptor(clazz), clazz.getModifiers(), TypeProxy.from(parentClass), clazz.isPrimitive());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TypeProxy && super.equals(obj);
    }
}

