/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.utils;

import java.util.ArrayList;
import org.objectweb.asm.Type;

public class DescriptorBuilder {
    private String returnType = Type.getDescriptor(Void.TYPE);
    private final ArrayList<String> params = new ArrayList();

    public DescriptorBuilder setReturnType(Class<?> returnType) {
        this.returnType = Type.getDescriptor(returnType);
        return this;
    }

    public DescriptorBuilder setReturnType(String returnType) {
        return this.setReturnType(returnType, 0);
    }

    public DescriptorBuilder setReturnType(String returnType, int arrayLevel) {
        this.returnType = DescriptorBuilder.nameToDescriptor(returnType, arrayLevel);
        return this;
    }

    public DescriptorBuilder addParameter(Class<?> param) {
        this.params.add(Type.getDescriptor(param));
        return this;
    }

    public DescriptorBuilder addParameter(String param) {
        return this.addParameter(param, 0);
    }

    public DescriptorBuilder addParameter(String param, int arrayLevel) {
        this.params.add(DescriptorBuilder.nameToDescriptor(param, arrayLevel));
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (String p : this.params) {
            sb.append(p);
        }
        sb.append(')').append(this.returnType);
        return sb.toString();
    }

    public static String nameToDescriptor(String name, int arrayLevel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arrayLevel; ++i) {
            sb.append('[');
        }
        sb.append('L').append(name.replace('.', '/')).append(';');
        return sb.toString();
    }
}

