/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.utils;

import ftbsc.lll.exceptions.InstructionMismatchException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;

public class InsnListUtils {
    public static InsnList of(AbstractInsnNode ... nodes) {
        InsnList list = new InsnList();
        for (AbstractInsnNode node : nodes) {
            list.add(node);
        }
        return list;
    }

    public static InsnList between(AbstractInsnNode startNode, AbstractInsnNode endNode) {
        InsnList list = new InsnList();
        while (startNode != null) {
            list.add(startNode);
            if (startNode == endNode) {
                return list;
            }
            startNode = startNode.getNext();
        }
        throw new InstructionMismatchException(list.getFirst(), list.getLast());
    }

    public static void replaceNode(InsnList list, AbstractInsnNode oldNode, AbstractInsnNode newNode) {
        list.insert(oldNode, newNode);
        list.remove(oldNode);
    }

    public static boolean replace(InsnList list, int opcode, AbstractInsnNode newNode, int amount, boolean reverse) {
        boolean changed = false;
        AbstractInsnNode cur = list.getFirst();
        while (cur != null && cur.getPrevious() != list.getLast() && cur.getNext() != list.getFirst()) {
            if (cur.getOpcode() == opcode) {
                InsnListUtils.replaceNode(list, cur, newNode);
                changed = true;
                if (--amount == 0) {
                    return changed;
                }
            }
            cur = reverse ? cur.getPrevious() : cur.getNext();
        }
        return changed;
    }

    public static void cut(InsnList list, int amount, boolean reverse) {
        for (int i = 0; i < amount; ++i) {
            list.remove(reverse ? list.getLast() : list.getFirst());
        }
    }
}

