/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.utils;

import ftbsc.lll.exceptions.PatternNotFoundException;
import ftbsc.lll.proxies.impl.FieldProxy;
import ftbsc.lll.proxies.impl.MethodProxy;
import ftbsc.lll.proxies.impl.TypeProxy;
import ftbsc.lll.utils.InsnListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatternMatcher {
    private final List<Predicate<AbstractInsnNode>> predicates;
    private final boolean reverse;
    private final boolean ignoreLabels;
    private final boolean ignoreFrames;
    private final boolean ignoreLineNumbers;

    private PatternMatcher(List<Predicate<AbstractInsnNode>> predicates, boolean reverse, boolean ignoreLabels, boolean ignoreFrames, boolean ignoreLineNumbers) {
        this.predicates = predicates;
        this.reverse = reverse;
        this.ignoreLabels = ignoreLabels;
        this.ignoreFrames = ignoreFrames;
        this.ignoreLineNumbers = ignoreLineNumbers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InsnList find(MethodNode node) {
        return this.find(this.reverse ? node.instructions.getLast() : node.instructions.getFirst());
    }

    public InsnList find(AbstractInsnNode node) {
        if (node != null) {
            AbstractInsnNode cur = node;
            while (cur != null) {
                if (this.predicates.isEmpty()) {
                    return InsnListUtils.of(cur);
                }
                AbstractInsnNode first = cur;
                AbstractInsnNode last = cur;
                int match = 0;
                while (last != null && match < this.predicates.size()) {
                    if (!(match != 0 && (this.ignoreLabels && last.getType() == 8 || this.ignoreFrames && last.getType() == 14 || this.ignoreLineNumbers && last.getType() == 15))) {
                        if (!this.predicates.get(match).test(last)) break;
                        if (match == this.predicates.size() - 1) {
                            if (this.reverse) {
                                return InsnListUtils.between(last, first);
                            }
                            return InsnListUtils.between(first, last);
                        }
                        ++match;
                    }
                    last = this.reverse ? last.getPrevious() : last.getNext();
                }
                cur = this.reverse ? cur.getPrevious() : cur.getNext();
            }
        }
        throw new PatternNotFoundException("Failed to find pattern!");
    }

    public static class Builder {
        private final List<Predicate<AbstractInsnNode>> predicates = new ArrayList<Predicate<AbstractInsnNode>>();
        private boolean reverse = false;
        private boolean ignoreLabels = false;
        private boolean ignoreFrames = false;
        private boolean ignoreLineNumbers = false;
        private static final BiPredicate<Object, Object> COMPARE_LABELS = (p, ex) -> {
            LabelNode expected = (LabelNode)ex;
            return expected.equals(p) || expected.getLabel().equals(p);
        };

        public PatternMatcher build() {
            return new PatternMatcher(this.predicates, this.reverse, this.ignoreLabels, this.ignoreFrames, this.ignoreLineNumbers);
        }

        public Builder reverse() {
            this.reverse = true;
            return this;
        }

        public Builder check(Predicate<AbstractInsnNode> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Builder any() {
            return this.check(i -> true);
        }

        public Builder opcode(int opcode) {
            return this.check(i -> i.getOpcode() == opcode);
        }

        public Builder opcodes(int ... opcodes) {
            Builder res = this;
            for (int o : opcodes) {
                res = this.opcode(o);
            }
            return res;
        }

        public Builder method() {
            return this.check(i -> i.getType() == 5);
        }

        public Builder field() {
            return this.check(i -> i.getType() == 4);
        }

        public Builder jump() {
            return this.check(i -> i.getType() == 7);
        }

        public Builder label() {
            return this.check(i -> i.getType() == 8);
        }

        public Builder node(int opcode, Object ... args) {
            return this.check(i -> Builder.matchNode(i, opcode, args));
        }

        private static boolean matchList(int startIdx, Object[] given, Object[] expected, boolean varargs, BiPredicate<Object, Object> predicate) {
            if (given.length <= startIdx) {
                return false;
            }
            if (given[startIdx] instanceof Object[]) {
                given = (Object[])given[startIdx];
                startIdx = 0;
            } else if (given[startIdx] instanceof List) {
                given = ((List)given[startIdx]).toArray();
                startIdx = 0;
            } else if (!varargs) {
                return false;
            }
            if (given.length - startIdx != expected.length) {
                return false;
            }
            while (startIdx < expected.length) {
                if (!predicate.test(given[startIdx], expected[startIdx])) {
                    return false;
                }
                ++startIdx;
            }
            return true;
        }

        private static boolean matchNode(AbstractInsnNode i, int opcode, Object ... args) {
            if (i.getOpcode() != opcode) {
                return false;
            }
            switch (i.getType()) {
                case 0: {
                    return args.length == 0;
                }
                case 7: {
                    JumpInsnNode jmp = (JumpInsnNode)i;
                    return args.length == 1 && (jmp.label.getLabel().equals(args[0]) || jmp.label.equals(args[0]));
                }
                case 6: {
                    if (args.length < 4) {
                        return false;
                    }
                    InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)i;
                    return indy.name.equals(args[0]) && indy.desc.equals(args[1]) && indy.bsm.equals(args[2]) && Builder.matchList(3, args, indy.bsmArgs, true, Object::equals);
                }
                case 1: {
                    return args.length == 1 && args[0] instanceof Integer && ((IntInsnNode)i).operand == (Integer)args[0];
                }
                case 10: {
                    IincInsnNode iinc = (IincInsnNode)i;
                    return args.length == 2 && args[0] instanceof Integer && args[1] instanceof Integer && iinc.var == (Integer)args[0] && iinc.incr == (Integer)args[1];
                }
                case 9: {
                    return args.length == 1 && Objects.equals(((LdcInsnNode)i).cst, args[0]);
                }
                case 12: {
                    if (args.length < 3) {
                        return false;
                    }
                    LookupSwitchInsnNode lookup = (LookupSwitchInsnNode)i;
                    return (lookup.dflt.equals(args[0]) || lookup.dflt.getLabel().equals(args[0])) && Builder.matchList(1, args, lookup.keys.toArray(), false, Object::equals) && Builder.matchList(2, args, lookup.labels.toArray(), false, Object::equals);
                }
                case 13: {
                    MultiANewArrayInsnNode mana = (MultiANewArrayInsnNode)i;
                    return args.length == 2 && args[1] instanceof Integer && mana.dims == (Integer)args[1] && mana.desc.equals(args[0] instanceof TypeProxy ? ((TypeProxy)args[0]).descriptor : args[0]);
                }
                case 5: {
                    MethodInsnNode method = (MethodInsnNode)i;
                    boolean methodMatch = true;
                    switch (args.length) {
                        case 2: {
                            methodMatch = args[1] instanceof Boolean && method.itf == (Boolean)args[1];
                        }
                        case 1: {
                            if (!(methodMatch &= args[0] instanceof MethodProxy)) break;
                            MethodProxy proxy = (MethodProxy)args[0];
                            return proxy.parent.internalName.equals(method.owner) && proxy.name.equals(method.name) && proxy.descriptor.equals(method.desc);
                        }
                        case 4: {
                            methodMatch = args[3] instanceof Boolean && method.itf == (Boolean)args[3];
                        }
                        case 3: {
                            return methodMatch && args[0].equals(method.owner) && args[1].equals(method.name) && args[2].equals(method.desc);
                        }
                    }
                    return false;
                }
                case 4: {
                    FieldInsnNode field = (FieldInsnNode)i;
                    if (args.length == 1 && args[0] instanceof FieldProxy) {
                        FieldProxy proxy = (FieldProxy)args[0];
                        return proxy.parent.internalName.equals(field.owner) && proxy.name.equals(field.name) && proxy.descriptor.equals(field.desc);
                    }
                    if (args.length == 3) {
                        return args[0].equals(field.owner) && args[1].equals(field.name) && args[2].equals(field.desc);
                    }
                    return false;
                }
                case 3: {
                    TypeInsnNode type = (TypeInsnNode)i;
                    if (args.length != 1) {
                        return false;
                    }
                    if (args[0] instanceof TypeProxy) {
                        return ((TypeProxy)args[0]).internalName.equals(type.desc);
                    }
                    return args[0].equals(type.desc);
                }
                case 11: {
                    if (args.length < 4) {
                        return false;
                    }
                    TableSwitchInsnNode tab = (TableSwitchInsnNode)i;
                    return args[0] instanceof Integer && tab.min == (Integer)args[0] && args[1] instanceof Integer && tab.min == (Integer)args[1] && COMPARE_LABELS.test(args[2], tab.dflt) && Builder.matchList(3, args, tab.labels.toArray(), true, COMPARE_LABELS);
                }
                case 2: {
                    return args.length == 1 && ((VarInsnNode)i).var == (Integer)args[0];
                }
            }
            return false;
        }

        public Builder ignoreLabels() {
            this.ignoreLabels = true;
            return this;
        }

        public Builder ignoreFrames() {
            this.ignoreFrames = true;
            return this;
        }

        public Builder ignoreLineNumbers() {
            this.ignoreLineNumbers = true;
            return this;
        }

        public Builder ignoreNoOps() {
            return this.ignoreLabels().ignoreFrames().ignoreLineNumbers();
        }
    }
}

