/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.utils.debug;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class BytecodePrinter {
    private static final Printer PRINTER = new Textifier();
    private static final TraceMethodVisitor MP = new TraceMethodVisitor(PRINTER);

    public static void logMethod(MethodNode main) {
        BytecodePrinter.logMethod(main, System.out::println);
    }

    public static void logMethod(MethodNode main, Consumer<String> logFn) {
        for (AbstractInsnNode i : main.instructions.toArray()) {
            logFn.accept(BytecodePrinter.insnToString(i));
        }
    }

    public static void logMethod(MethodNode main, String path) {
        StringBuilder out = new StringBuilder();
        BytecodePrinter.logMethod(main, out::append);
        try {
            Files.write(Paths.get(path, new String[0]), out.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String insnToString(AbstractInsnNode insn) {
        insn.accept((MethodVisitor)MP);
        StringWriter sw = new StringWriter();
        PRINTER.print(new PrintWriter(sw));
        PRINTER.getText().clear();
        return sw.toString();
    }
}

