/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.gradle;

import ftbsc.lll.gradle.LilleroGradleExtension;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

public class LilleroGradlePlugin
implements Plugin<Project> {
    private static final String PLUGIN_ID = "lillero";
    private static final String JAVA_PLUGIN_ID = "java";
    private static final String JAVA_LIBRARY_PLUGIN_ID = "java-library";
    private static final String FORGE_GRADLE_PLUGIN_ID = "net.minecraftforge.gradle";
    private static final String SHADOW_PLUGIN_ID = "com.gradleup.shadow";
    private static final String SHADOW_OLD_PLUGIN_ID = "com.github.johnrengelman.shadow";
    public static final String LOOM_PLUGIN_ID = "fabric-loom";
    private static final String CORE_DEPSTRING = "ftbsc:lll:";
    private static final String PROCESSOR_DEPSTRING = "ftbsc.lll:processor:";
    private static final String MIXIN_DEPSTRING = "ftbsc.lll:mixin:";
    private static final String LOADER_DEPSTRING = "ftbsc.lll:loader:";

    public void apply(@NotNull Project proj) {
        LilleroGradleExtension extension = (LilleroGradleExtension)proj.getExtensions().create(PLUGIN_ID, LilleroGradleExtension.class, new Object[]{proj});
        if (((Boolean)extension.getRegisterRepo().get()).booleanValue()) {
            proj.getRepositories().maven(repo -> {
                repo.setName("zaaarf");
                repo.setUrl((Object)"https://maven.zaaarf.foo");
                repo.content(c -> {
                    c.includeGroup("ftbsc");
                    c.includeGroup("ftbsc.lll");
                });
            });
        }
        LilleroGradlePlugin.configureCompilerArgs(proj, extension);
        proj.afterEvaluate(project -> {
            if (!project.getPlugins().hasPlugin(JAVA_PLUGIN_ID) && !project.getPlugins().hasPlugin(JAVA_LIBRARY_PLUGIN_ID)) {
                return;
            }
            project.getDependencies().add("implementation", (Object)(CORE_DEPSTRING + (String)extension.getCoreVersion().get()));
            if (((Boolean)extension.getShadow().get()).booleanValue()) {
                LilleroGradlePlugin.shade(project, CORE_DEPSTRING + (String)extension.getCoreVersion().get());
            }
            project.getDependencies().add("compileOnly", (Object)(PROCESSOR_DEPSTRING + (String)extension.getProcessorVersion().get()));
            project.getDependencies().add("annotationProcessor", (Object)(PROCESSOR_DEPSTRING + (String)extension.getProcessorVersion().get()));
            if (((Boolean)extension.getAuto().get()).booleanValue() && project.getPlugins().hasPlugin(LOOM_PLUGIN_ID)) {
                project.getDependencies().add("implementation", (Object)(MIXIN_DEPSTRING + (String)extension.getMixinVersion().get()));
                if (((Boolean)extension.getShadow().get()).booleanValue()) {
                    LilleroGradlePlugin.shade(project, MIXIN_DEPSTRING + (String)extension.getMixinVersion().get());
                }
            }
        });
    }

    private static void configureCompilerArgs(Project project, LilleroGradleExtension extension) {
        project.getGradle().getTaskGraph().whenReady(graph -> project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> {
            List compilerArgs = javaCompile.getOptions().getCompilerArgs();
            extension.getMappingsConfiguration().appendCompilerArgs(compilerArgs);
            extension.getFakeMixinConfiguration().appendCompilerArgs(compilerArgs);
            compilerArgs.add("-AanonymousClassWarning=" + String.valueOf(extension.getAnonymousClassWarning().get()));
            compilerArgs.add("-AmanualClassWarning=" + String.valueOf(extension.getManualClassWarning().get()));
            compilerArgs.add("-AobfuscateInjectorMetadata=" + String.valueOf(extension.getObfuscateInjectorMetadata().get()));
            compilerArgs.add("-AnoServiceProvider=" + String.valueOf(extension.getNoServiceProvider().get()));
        }));
    }

    private static void shade(Project project, String dep) {
        if (project.getPlugins().hasPlugin(SHADOW_PLUGIN_ID) || project.getPlugins().hasPlugin(SHADOW_OLD_PLUGIN_ID)) {
            Dependency shadedDep = project.getDependencies().create((Object)dep);
            if (shadedDep instanceof ModuleDependency) {
                ((ModuleDependency)shadedDep).setTransitive(false);
            }
            project.getDependencies().add("shadow", (Object)shadedDep);
        }
    }
}

