/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.mapper;

import ftbsc.lll.exceptions.InvalidResourceException;
import ftbsc.lll.mapper.IMappingFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;

public class MapperProvider {
    private static MapperProvider INSTANCE = null;
    private Set<IMappingFormat> loadedMappers = null;

    private static MapperProvider getInstance() {
        return INSTANCE == null ? (INSTANCE = new MapperProvider()) : INSTANCE;
    }

    private void loadMappers() {
        this.loadedMappers = new HashSet<IMappingFormat>();
        for (IMappingFormat mapper : ServiceLoader.load(IMappingFormat.class, this.getClass().getClassLoader())) {
            this.loadedMappers.add(mapper);
        }
        if (this.loadedMappers.isEmpty()) {
            throw new RuntimeException("Something went wrong: no mapper types were loaded successfully!");
        }
    }

    public static IMappingFormat getMapper(List<String> data) {
        if (MapperProvider.getInstance().loadedMappers == null) {
            MapperProvider.getInstance().loadMappers();
        }
        return MapperProvider.getInstance().loadedMappers.stream().filter(m -> m.claim(data)).max(Comparator.comparingInt(IMappingFormat::priority)).orElseThrow(InvalidResourceException::new);
    }

    public static List<String> fetchFromLocalOrRemote(String location) {
        InputStream targetStream;
        try {
            URI target = new URI(location);
            targetStream = target.toURL().openStream();
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            File f = new File(location);
            try {
                targetStream = new FileInputStream(f);
            }
            catch (FileNotFoundException ex) {
                throw new InvalidResourceException(location);
            }
        }
        return new BufferedReader(new InputStreamReader(targetStream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
    }
}

