/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.mapper.data;

import ftbsc.lll.exceptions.MappingNotFoundException;
import ftbsc.lll.mapper.data.FieldData;
import ftbsc.lll.mapper.data.MethodData;
import ftbsc.lll.mapper.data.MethodSignature;
import ftbsc.lll.mapper.utils.Mapper;
import ftbsc.lll.mapper.utils.MappingUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassData {
    public final String name;
    public final String nameMapped;
    private final Map<MethodSignature, MethodData> methods;
    private final Map<String, FieldData> fields;

    public ClassData(String name, String nameMapped) {
        this.name = name;
        this.nameMapped = nameMapped;
        this.methods = new HashMap<MethodSignature, MethodData>();
        this.fields = new HashMap<String, FieldData>();
    }

    public void addMethod(String name, String nameMapped, String descriptor) {
        MethodData data = new MethodData(this, name, nameMapped, descriptor);
        this.methods.put(data.signature, data);
    }

    public void addField(String plain, String mapped) {
        this.fields.put(plain, new FieldData(this, plain, mapped));
    }

    public void addField(String plain, String mapped, String descriptor) {
        this.fields.put(plain, new FieldData(this, plain, mapped, descriptor));
    }

    public ClassData generateReverseMappings(Mapper mapper) {
        ClassData reverse = new ClassData(this.nameMapped, this.name);
        this.methods.forEach((signature, data) -> reverse.addMethod(data.nameMapped, signature.name, MappingUtils.mapMethodDescriptor(signature.descriptor, mapper, false)));
        this.fields.forEach((name, data) -> reverse.addField(data.nameMapped, (String)name, data.descriptor));
        return reverse;
    }

    public MethodData mapMethod(String methodName, String methodDescriptor) {
        List signatures = this.methods.keySet().stream().filter(s -> s.name.equals(methodName) && s.descriptor.startsWith(methodDescriptor)).collect(Collectors.toList());
        if (signatures.size() > 1) {
            throw new RuntimeException();
        }
        if (signatures.isEmpty()) {
            throw new MappingNotFoundException("method", String.format("%s::%s%s", this.name, methodName, methodDescriptor));
        }
        return this.methods.get(signatures.get(0));
    }

    public FieldData mapField(String fieldName) {
        FieldData data = this.fields.get(fieldName);
        if (data == null) {
            throw new MappingNotFoundException("field", String.format("%s.%s", this.name, fieldName));
        }
        return data;
    }

    public Map<MethodSignature, MethodData> getMethods() {
        return this.methods;
    }

    public Map<String, FieldData> getFields() {
        return this.fields;
    }
}

