/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.mapper.impl;

import com.google.auto.service.AutoService;
import ftbsc.lll.exceptions.MalformedMappingsException;
import ftbsc.lll.mapper.IMappingFormat;
import ftbsc.lll.mapper.MapperProvider;
import ftbsc.lll.mapper.data.ClassData;
import ftbsc.lll.mapper.utils.Mapper;
import ftbsc.lll.mapper.utils.MappingUtils;
import java.util.ArrayList;
import java.util.List;

@AutoService(value={IMappingFormat.class})
public class MultiMapper
implements IMappingFormat {
    @Override
    public boolean claim(List<String> lines) {
        return lines.get(0).equals("lll multimapper");
    }

    @Override
    public Mapper getMapper(List<String> lines, String from, String to, boolean ignoreErrors) throws MalformedMappingsException {
        Mapper result = new Mapper();
        ArrayList<Mapper> mapperList = new ArrayList<Mapper>();
        for (int i = 1; i < lines.size(); ++i) {
            List<String> data2 = MapperProvider.fetchFromLocalOrRemote(lines.get(i));
            IMappingFormat format = MapperProvider.getMapper(data2);
            mapperList.add(format.getMapper(data2, from, to, ignoreErrors));
        }
        ((Mapper)mapperList.get(0)).getRawMappings().forEach((name, data) -> {
            ClassData finalData = data;
            for (int i = 1; i < mapperList.size(); ++i) {
                finalData = ((Mapper)mapperList.get(i)).getClassData(finalData.nameMapped);
            }
            ClassData sumData = new ClassData(data.name, finalData.nameMapped);
            data.getMethods().forEach((signature, methodData) -> {
                for (int i = 1; i < mapperList.size(); ++i) {
                    Mapper mapper = (Mapper)mapperList.get(i);
                    methodData = mapper.getMethodData(methodData.parentClass.nameMapped, methodData.nameMapped, MappingUtils.mapMethodDescriptor(methodData.signature.descriptor, mapper, false));
                }
                sumData.addMethod(signature.name, methodData.nameMapped, signature.descriptor);
            });
            data.getFields().forEach((fieldName, fieldData) -> {
                for (int i = 1; i < mapperList.size(); ++i) {
                    fieldData = ((Mapper)mapperList.get(i)).getFieldData(fieldData.parentClass.nameMapped, fieldData.nameMapped);
                }
                sumData.addField((String)fieldName, fieldData.nameMapped, fieldData.descriptor);
            });
            result.getRawMappings().put(sumData.name, sumData);
        });
        return result;
    }
}

