/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.mapper.impl;

import com.google.auto.service.AutoService;
import ftbsc.lll.exceptions.MalformedMappingsException;
import ftbsc.lll.mapper.IMappingFormat;
import ftbsc.lll.mapper.data.ClassData;
import ftbsc.lll.mapper.utils.Mapper;
import java.util.List;

@AutoService(value={IMappingFormat.class})
public class SRGMapper
implements IMappingFormat {
    @Override
    public boolean claim(List<String> lines) {
        String[] firstLineTokens = lines.get(0).trim().split(" ");
        return firstLineTokens.length <= 5 && (firstLineTokens[0].equals("CL:") || firstLineTokens[0].equals("MD:") || firstLineTokens[0].equals("FD:"));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Mapper buildMapper(List<String> lines, boolean ignoreErrors, boolean inverted) throws MalformedMappingsException {
        Mapper mapper;
        Mapper mapper2 = new Mapper();
        Mapper invertedMapper = new Mapper();
        block9: for (int i = 0; i < lines.size(); ++i) {
            String[] tokens = lines.get(i).trim().split(" ");
            switch (tokens[0]) {
                case "CL:": {
                    if (tokens.length != 3) break;
                    this.registerClass(mapper2, invertedMapper, tokens[1], tokens[2]);
                    continue block9;
                }
                case "MD:": 
                case "FD:": {
                    if (this.processMemberTokens(mapper2, invertedMapper, tokens)) continue block9;
                }
            }
            if (ignoreErrors) continue;
            throw new MalformedMappingsException(i, "wrong number of space-separated tokens");
        }
        if (inverted) {
            mapper = invertedMapper;
            return mapper;
        }
        mapper = mapper2;
        return mapper;
    }

    private boolean processMemberTokens(Mapper mapper, Mapper invertedMapper, String[] tokens) {
        boolean field;
        if (tokens[0].equals("MD:")) {
            if (tokens.length != 5) {
                return false;
            }
            field = false;
        } else if (tokens[0].equals("FD:")) {
            if (tokens.length != 3) {
                return false;
            }
            field = true;
        } else {
            return false;
        }
        String[] split = tokens[1].split("/");
        String memberName = split[split.length - 1];
        String parent = tokens[1].substring(0, tokens[1].length() - split[split.length - 1].length() - 1);
        int mappedPosition = field ? 2 : 3;
        split = tokens[mappedPosition].split("/");
        String memberNameMapped = split[split.length - 1];
        String parentMapped = tokens[mappedPosition].substring(0, tokens[mappedPosition].length() - split[split.length - 1].length() - 1);
        this.registerMember(mapper, invertedMapper, parent, parentMapped, memberName, memberNameMapped, field ? null : tokens[2], field ? null : tokens[4]);
        return true;
    }

    private void registerClass(Mapper mapper, Mapper invertedMapper, String name, String nameMapped) {
        if (mapper.getRawMappings().containsKey(name)) {
            return;
        }
        mapper.getRawMappings().put(name, new ClassData(name, nameMapped));
        invertedMapper.getRawMappings().put(nameMapped, new ClassData(nameMapped, name));
    }

    private void registerMember(Mapper mapper, Mapper invertedMapper, String parent, String parentMapped, String name, String nameMapped, String descriptor, String descriptorMapped) {
        this.registerClass(mapper, invertedMapper, parent, parentMapped);
        ClassData data = mapper.getClassData(parent);
        ClassData dataReverse = invertedMapper.getClassData(data.nameMapped);
        if (descriptor == null || descriptorMapped == null) {
            data.addField(name, nameMapped);
            dataReverse.addField(nameMapped, name);
        } else {
            data.addMethod(name, nameMapped, descriptor);
            dataReverse.addMethod(nameMapped, name, descriptorMapped);
        }
    }

    @Override
    public Mapper getMapper(List<String> lines, String from, String to, boolean ignoreErrors) throws MalformedMappingsException {
        return this.buildMapper(lines, ignoreErrors, false);
    }

    @Override
    public Mapper getInvertedMapper(List<String> lines, String from, String to, boolean ignoreErrors) {
        return this.buildMapper(lines, ignoreErrors, true);
    }
}

