/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.mapper.utils;

import ftbsc.lll.exceptions.MappingNotFoundException;
import ftbsc.lll.mapper.data.ClassData;
import ftbsc.lll.mapper.data.FieldData;
import ftbsc.lll.mapper.data.MethodData;
import java.util.HashMap;
import java.util.Map;

public class Mapper {
    protected final Map<String, ClassData> mappings = new HashMap<String, ClassData>();

    public ClassData getClassData(String name) throws MappingNotFoundException {
        ClassData data = this.mappings.get(name.replace('.', '/'));
        if (data == null) {
            throw new MappingNotFoundException("class", name);
        }
        return data;
    }

    public MethodData getMethodData(String parent, String name, String descriptor) throws MappingNotFoundException {
        return this.getClassData(parent).mapMethod(name, descriptor);
    }

    public FieldData getFieldData(String parent, String name) throws MappingNotFoundException {
        return this.getClassData(parent).mapField(name);
    }

    public Map<String, ClassData> getRawMappings() {
        return this.mappings;
    }

    public Mapper getInverted() {
        Mapper inverted = new Mapper();
        this.mappings.forEach((name, data) -> {
            ClassData reverse = data.generateReverseMappings(this);
            inverted.mappings.put(data.nameMapped, reverse);
        });
        return inverted;
    }
}

