/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.mapper.utils;

import ftbsc.lll.exceptions.MappingNotFoundException;
import ftbsc.lll.mapper.utils.Mapper;
import ftbsc.lll.utils.DescriptorBuilder;
import org.objectweb.asm.Type;

public class MappingUtils {
    public static String mapMethodDescriptor(String descriptor, Mapper mapper, boolean reverse) {
        Type method = Type.getMethodType((String)descriptor);
        Type[] arguments = method.getArgumentTypes();
        Type returnType = method.getReturnType();
        Type[] mappedArguents = new Type[arguments.length];
        for (int i = 0; i < mappedArguents.length; ++i) {
            mappedArguents[i] = MappingUtils.mapType(arguments[i], mapper, reverse);
        }
        return Type.getMethodDescriptor((Type)MappingUtils.mapType(returnType, mapper, reverse), (Type[])mappedArguents);
    }

    public static Type mapType(Type type, Mapper mapper, boolean reverse) {
        Type unwrapped = type;
        int arrayLevel = 0;
        while (unwrapped.getSort() == 9) {
            unwrapped = unwrapped.getElementType();
            ++arrayLevel;
        }
        if (type.getSort() < 9) {
            return type;
        }
        String internalName = type.getInternalName();
        try {
            String internalNameMapped = reverse ? mapper.getInverted().getClassData((String)internalName).nameMapped : mapper.getClassData((String)internalName).nameMapped;
            return Type.getType((String)DescriptorBuilder.nameToDescriptor((String)internalNameMapped, (int)arrayLevel));
        }
        catch (MappingNotFoundException e) {
            return type;
        }
    }
}

