/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import ftbsc.lll.IInjector;
import ftbsc.lll.exceptions.OrphanElementException;
import ftbsc.lll.processor.ProcessorOptions;
import ftbsc.lll.processor.annotations.BareInjector;
import ftbsc.lll.processor.annotations.Find;
import ftbsc.lll.processor.annotations.Injector;
import ftbsc.lll.processor.annotations.Patch;
import ftbsc.lll.processor.annotations.Target;
import ftbsc.lll.processor.containers.ClassContainer;
import ftbsc.lll.processor.containers.FinderInfo;
import ftbsc.lll.processor.containers.InjectorInfo;
import ftbsc.lll.processor.containers.MethodContainer;
import ftbsc.lll.processor.utils.ASTUtils;
import ftbsc.lll.processor.utils.JavaPoetUtils;
import ftbsc.lll.proxies.ProxyType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"ftbsc.lll.processor.annotations.Patch", "ftbsc.lll.processor.annotations.BareInjector"})
public class LilleroProcessor
extends AbstractProcessor {
    private final Set<String> injectors = new HashSet<String>();
    private final Map<ClassName, Boolean> targets = new HashMap<ClassName, Boolean>();
    private ProcessorOptions options = null;

    @Override
    public Set<String> getSupportedOptions() {
        return ProcessorOptions.SUPPORTED;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public ProcessorOptions getProcessorOptions() {
        if (this.options == null) {
            this.options = new ProcessorOptions(this.processingEnv);
        }
        return this.options;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ProcessorOptions options = this.getProcessorOptions();
        for (TypeElement typeElement : annotations) {
            if (typeElement.getQualifiedName().contentEquals(Patch.class.getName())) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    TypeElement typeElement2 = (TypeElement)element;
                    if (options.fakeMixin != null && element.getAnnotation(BareInjector.class) != null) {
                        this.markClassAsTarget(typeElement2);
                        continue;
                    }
                    if (!this.isValidInjector(typeElement2)) continue;
                    this.generateClasses(typeElement2);
                    if (options.fakeMixin == null) continue;
                    this.markClassAsTarget(typeElement2);
                }
                continue;
            }
            if (!typeElement.getQualifiedName().contentEquals(BareInjector.class.getName())) continue;
            TypeMirror injectorType = this.processingEnv.getElementUtils().getTypeElement("ftbsc.lll.IInjector").asType();
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                TypeElement type = (TypeElement)element;
                if (this.processingEnv.getTypeUtils().isAssignable(element.asType(), injectorType)) {
                    this.injectors.add(type.getQualifiedName().toString());
                    continue;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Class %s annotated with @BareInjector is not an instance of IInjector, skipping...", type.getQualifiedName().toString()));
            }
        }
        if (options.fakeMixin != null && !this.injectors.isEmpty()) {
            this.generateFakeMixinClasses(options.fakeMixin);
        }
        if (!options.noServiceProvider && !this.injectors.isEmpty()) {
            this.generateServiceProvider();
            return true;
        }
        return false;
    }

    private boolean isValidInjector(TypeElement elem) {
        TypeMirror classNodeType = this.processingEnv.getElementUtils().getTypeElement("org.objectweb.asm.tree.ClassNode").asType();
        TypeMirror methodNodeType = this.processingEnv.getElementUtils().getTypeElement("org.objectweb.asm.tree.MethodNode").asType();
        if (elem.getEnclosedElements().stream().anyMatch(e -> e.getAnnotation(Target.class) != null) && elem.getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).anyMatch(e -> {
            if (e.getAnnotation(Injector.class) == null) {
                return false;
            }
            if (e.getAnnotation(Target.class) != null) {
                return false;
            }
            List effectiveParams = ((ExecutableElement)e).getParameters().stream().filter(p -> p.getAnnotation(Find.class) == null).collect(Collectors.toList());
            return effectiveParams.size() == 1 && this.processingEnv.getTypeUtils().isSameType(((VariableElement)effectiveParams.get(0)).asType(), methodNodeType) || effectiveParams.size() == 2 && effectiveParams.stream().anyMatch(p -> this.processingEnv.getTypeUtils().isSameType(p.asType(), classNodeType)) && effectiveParams.stream().anyMatch(p -> this.processingEnv.getTypeUtils().isSameType(p.asType(), methodNodeType));
        })) {
            return true;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Missing valid @Injector method in @Patch class %s, skipping...", elem));
        return false;
    }

    private void markClassAsTarget(TypeElement type) {
        ClassName name;
        Patch ann = type.getAnnotation(Patch.class);
        boolean asClass = ann.fqn().isEmpty();
        if (asClass) {
            name = ClassName.get((TypeElement)((TypeElement)this.processingEnv.getTypeUtils().asElement(ASTUtils.getTypeFromAnnotation(ann, Patch::value, this.processingEnv))));
        } else {
            String fqn = ann.fqn();
            int lastDot = fqn.lastIndexOf(46);
            String[] classNames = fqn.substring(lastDot + 1).split("\\$");
            name = ClassName.get((String)fqn.substring(0, lastDot), (String)classNames[0], (String[])Arrays.copyOfRange(classNames, 1, classNames.length));
        }
        for (String inner : ann.inner()) {
            name = name.nestedClass(inner);
            if (ASTUtils.shouldValidate(inner)) continue;
            asClass = false;
        }
        if (asClass) {
            this.targets.put(name, true);
        } else {
            this.targets.putIfAbsent(name, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateClasses(TypeElement cl) {
        Patch patchAnn = cl.getAnnotation(Patch.class);
        ProcessorOptions opts = this.getProcessorOptions();
        ClassContainer targetClass = ClassContainer.from(patchAnn, Patch::value, patchAnn.fqn(), patchAnn.inner(), opts);
        List<ExecutableElement> targets = ASTUtils.findAnnotatedEnclosedElements(cl, Target.class);
        List<ExecutableElement> injectors = ASTUtils.findAnnotatedEnclosedElements(cl, Injector.class);
        List<VariableElement> finders = ASTUtils.findAnnotatedEnclosedElements(cl, Find.class);
        for (ExecutableElement injector : injectors) {
            for (VariableElement variableElement : injector.getParameters()) {
                if (variableElement.getAnnotation(Find.class) == null) continue;
                finders.add(variableElement);
            }
        }
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        HashMap<ExecutableElement, Object> toGenerate = new HashMap<ExecutableElement, Object>();
        HashMap<VariableElement, FinderInfo> matchedFinders = new HashMap<VariableElement, FinderInfo>();
        boolean bl = false;
        for (ExecutableElement executableElement : targets) {
            for (Target targetAnn : (Target[])executableElement.getAnnotationsByType(Target.class)) {
                Object info;
                Element matched = ASTUtils.matchTarget(cl, executableElement, targetAnn, injectors, finders, this.processingEnv);
                if (matched instanceof ExecutableElement) {
                    void var11_13;
                    info = new InjectorInfo(String.format("%sInjector%d", JavaPoetUtils.generateRealClassName(cl), (int)(++var11_13)), (ExecutableElement)matched, executableElement, targetAnn, this.getProcessorOptions());
                    toGenerate.put(((InjectorInfo)info).injector, info);
                    continue;
                }
                if (!(matched instanceof VariableElement)) continue;
                info = new FinderInfo(cl, (VariableElement)matched, executableElement, targetAnn);
                matchedFinders.put(((FinderInfo)info).proxy, (FinderInfo)info);
            }
        }
        for (VariableElement variableElement : finders) {
            ProxyType type = ASTUtils.getProxyType(variableElement);
            if (type == ProxyType.TYPE) {
                matchedFinders.put(variableElement, new FinderInfo(cl, variableElement, null, null));
                continue;
            }
            if (type != ProxyType.FIELD) continue;
            matchedFinders.put(variableElement, new FinderInfo(cl, variableElement, null, null));
        }
        for (ExecutableElement executableElement : injectors) {
            if (toGenerate.containsKey(executableElement)) continue;
            throw new OrphanElementException(executableElement);
        }
        for (VariableElement variableElement : finders) {
            if (matchedFinders.containsKey(variableElement)) continue;
            throw new OrphanElementException(variableElement);
        }
        for (FinderInfo finderInfo : matchedFinders.values()) {
            if (finderInfo.proxy.getEnclosingElement() instanceof ExecutableElement) {
                InjectorInfo injInfo = (InjectorInfo)toGenerate.get((ExecutableElement)finderInfo.proxy.getEnclosingElement());
                if (injInfo != null) {
                    injInfo.finderParams.add(finderInfo);
                    continue;
                }
                throw new OrphanElementException(finderInfo.proxy);
            }
            finderInfo.appendToMethodSpec(constructorBuilder, false, this.options);
        }
        for (InjectorInfo injectorInfo : toGenerate.values()) {
            MethodContainer target = injectorInfo.target;
            TypeSpec injectorClass = TypeSpec.classBuilder((String)injectorInfo.name).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(cl.asType()).addSuperinterface((TypeName)ClassName.get(IInjector.class)).addMethod(constructorBuilder.build()).addMethod(JavaPoetUtils.buildStringReturnMethod("name", injectorInfo.name)).addMethod(JavaPoetUtils.buildStringReturnMethod("reason", injectorInfo.reason)).addMethod(JavaPoetUtils.buildStringReturnMethod("targetClass", this.getProcessorOptions().obfuscateInjectorMetadata ? targetClass.data.nameMapped.replace('/', '.') : targetClass.data.name.replace('/', '.'))).addMethod(JavaPoetUtils.buildStringReturnMethod("methodName", this.getProcessorOptions().obfuscateInjectorMetadata ? target.data.nameMapped : target.data.signature.name)).addMethod(JavaPoetUtils.buildStringReturnMethod("methodDesc", this.getProcessorOptions().obfuscateInjectorMetadata ? target.descriptorObf : target.data.signature.name)).addMethods(JavaPoetUtils.generateDummies(cl)).addMethod(injectorInfo.generateInjector(this.options)).build();
            this.injectors.add(JavaPoetUtils.writeClass(this.processingEnv.getFiler(), injectorInfo.outputPackage, injectorInfo.name, injectorClass));
        }
    }

    private void generateFakeMixinClasses(String fqn) {
        int lastPeriod = fqn.lastIndexOf(46);
        String pkg = fqn.substring(0, Math.max(0, lastPeriod));
        String clazz = fqn.substring(lastPeriod + 1);
        AnnotationSpec.Builder mixinAnn = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.spongepowered.asm.mixin", (String)"Mixin", (String[])new String[0]));
        boolean isPseudo = false;
        for (Map.Entry<ClassName, Boolean> targetName : this.targets.entrySet()) {
            if (targetName.getValue().booleanValue()) {
                mixinAnn.addMember("value", "$T.class", new Object[]{targetName.getKey()});
                continue;
            }
            mixinAnn.addMember("targets", "$S", new Object[]{targetName.getKey().reflectionName()});
            isPseudo = true;
        }
        TypeSpec.Builder spec = TypeSpec.classBuilder((String)clazz).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (isPseudo) {
            spec.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.spongepowered.asm.mixin", (String)"Pseudo", (String[])new String[0])).build());
        }
        JavaPoetUtils.writeClass(this.processingEnv.getFiler(), pkg, clazz, spec.addAnnotation(mixinAnn.build()).build());
    }

    private void generateServiceProvider() {
        try {
            FileObject serviceProvider = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/ftbsc.lll.IInjector", new Element[0]);
            PrintWriter out = new PrintWriter(serviceProvider.openWriter());
            this.injectors.forEach(out::println);
            this.injectors.clear();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

