/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor;

import ftbsc.lll.mapper.MapperProvider;
import ftbsc.lll.mapper.utils.Mapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;

public class ProcessorOptions {
    public static final Set<String> SUPPORTED = new HashSet<String>(Arrays.asList("mappingsFile", "mappingsNamespaceFrom", "mappingsNamespaceTo", "anonymousClassWarning", "manualClassWarning", "obfuscateInjectorMetadata", "noServiceProvider", "fakeMixin", "outputPackage"));
    public final ProcessingEnvironment env;
    public final Mapper mapper;
    public final boolean anonymousClassWarning;
    public final boolean manualClassWarning;
    public final boolean obfuscateInjectorMetadata;
    public final boolean noServiceProvider;
    public final String fakeMixin;
    public final String outputPackage;

    public ProcessorOptions(ProcessingEnvironment env) {
        this.env = env;
        String location = env.getOptions().get("mappingsFile");
        String namespaceFrom = env.getOptions().get("mappingsNamespaceFrom");
        String namespaceTo = env.getOptions().get("mappingsNamespaceTo");
        if (location != null) {
            List lines = MapperProvider.fetchFromLocalOrRemote((String)location);
            this.mapper = MapperProvider.getMapper((List)lines).getMapper(lines, namespaceFrom, namespaceTo, true);
        } else {
            this.mapper = null;
        }
        this.anonymousClassWarning = ProcessorOptions.parseBooleanArg(env.getOptions().get("anonymousClassWarning"), true);
        this.manualClassWarning = ProcessorOptions.parseBooleanArg(env.getOptions().get("manualClassWarning"), true);
        this.obfuscateInjectorMetadata = ProcessorOptions.parseBooleanArg(env.getOptions().get("obfuscateInjectorMetadata"), true);
        this.noServiceProvider = ProcessorOptions.parseBooleanArg(env.getOptions().get("noServiceProvider"), false);
        this.fakeMixin = env.getOptions().get("fakeMixin");
        this.outputPackage = env.getOptions().get("outputPackage");
    }

    private static boolean parseBooleanArg(String arg, boolean defaultValue) {
        if (arg == null) {
            return defaultValue;
        }
        try {
            int i = Integer.parseInt(arg);
            return i != 0;
        }
        catch (NumberFormatException ignored) {
            return Boolean.parseBoolean(arg);
        }
    }
}

