/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor.containers;

import ftbsc.lll.exceptions.TargetNotFoundException;
import ftbsc.lll.mapper.data.ClassData;
import ftbsc.lll.processor.ProcessorOptions;
import ftbsc.lll.processor.annotations.Find;
import ftbsc.lll.processor.annotations.Patch;
import ftbsc.lll.processor.utils.ASTUtils;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class ClassContainer {
    public final ClassData data;
    public final TypeElement elem;

    private ClassContainer(String fqn, String[] innerNames, ProcessorOptions options, boolean manual) {
        TypeElement elem = options.env.getElementUtils().getTypeElement(fqn);
        if (elem == null) {
            if (manual) {
                if (options.manualClassWarning) {
                    options.env.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Manually-specified class %s and its children cannot not be verified by the processor!", fqn));
                }
            } else {
                throw new TargetNotFoundException("class", fqn);
            }
        }
        StringBuilder fqnBuilder = new StringBuilder(manual ? fqn : ASTUtils.internalNameFromType(elem.asType(), options.env).replace('/', '.'));
        if (innerNames != null) {
            boolean skip = false;
            for (String inner : innerNames) {
                if (inner != null) {
                    fqnBuilder.append('$').append(inner);
                }
                if (skip) continue;
                if (elem == null || !ASTUtils.shouldValidate(inner)) {
                    if (options.anonymousClassWarning) {
                        options.env.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Anonymous class %s$%s and its children cannot be verified by the processor!", fqnBuilder, inner));
                    }
                    elem = null;
                    skip = true;
                    continue;
                }
                elem = elem.getEnclosedElements().stream().filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).filter(e -> e.getSimpleName().contentEquals(inner)).findFirst().orElse(null);
                if (elem != null) continue;
                throw new TargetNotFoundException("class", inner);
            }
        }
        this.data = ASTUtils.getClassData(fqnBuilder.toString(), options.mapper);
        this.elem = elem;
    }

    public static <T extends Annotation> ClassContainer from(T ann, Function<T, Class<?>> classFunction, String fqn, String[] innerNames, ProcessorOptions options) {
        String chosenFqn = fqn.isEmpty() ? ASTUtils.getTypeFromAnnotation(ann, classFunction, options.env).toString() : fqn;
        String[] inner = innerNames != null && innerNames.length != 0 ? String.join((CharSequence)"$", innerNames).split("\\$") : null;
        return new ClassContainer(chosenFqn, inner, options, !fqn.isEmpty());
    }

    public static ClassContainer findOrFallback(TypeElement fallback, Patch p, Find f, ProcessorOptions options) {
        if (f == null) {
            return ClassContainer.from(p, Patch::value, p.fqn(), p.inner(), options);
        }
        ClassContainer cl = ClassContainer.from(f, Find::value, f.fqn(), f.inner(), options);
        return cl.data.name.equals("java/lang/Object") ? new ClassContainer(fallback.getQualifiedName().toString(), null, options, false) : cl;
    }
}

