/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor.containers;

import ftbsc.lll.exceptions.AmbiguousDefinitionException;
import ftbsc.lll.mapper.data.FieldData;
import ftbsc.lll.mapper.utils.Mapper;
import ftbsc.lll.mapper.utils.MappingUtils;
import ftbsc.lll.processor.ProcessorOptions;
import ftbsc.lll.processor.annotations.Find;
import ftbsc.lll.processor.annotations.Patch;
import ftbsc.lll.processor.containers.ClassContainer;
import ftbsc.lll.processor.utils.ASTUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Function;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.objectweb.asm.Type;

public class FieldContainer {
    public final FieldData data;
    public final String descriptor;
    public final String descriptorObf;
    public final ClassContainer parent;
    public final VariableElement elem;

    private FieldContainer(ClassContainer parent, String name, String descriptor, ProcessorOptions options) {
        this.parent = parent;
        if (parent.elem == null) {
            if (descriptor == null) {
                throw new AmbiguousDefinitionException("Cannot use name-based lookups for fields of unverifiable classes!");
            }
            this.elem = null;
            this.descriptor = descriptor;
        } else {
            this.elem = (VariableElement)ASTUtils.findMember(parent, name, descriptor, descriptor != null, true, options.env);
            this.descriptor = ASTUtils.descriptorFromType(this.elem.asType(), options.env);
            name = this.elem.getSimpleName().toString();
        }
        this.data = ASTUtils.getFieldData(parent.data.name, name, options.mapper);
        this.descriptorObf = options.mapper == null ? this.descriptor : MappingUtils.mapType((Type)Type.getType((String)this.descriptor), (Mapper)options.mapper, (boolean)false).getDescriptor();
    }

    public static FieldContainer from(VariableElement finder, ProcessorOptions opts) {
        Patch p = finder.getEnclosingElement().getAnnotation(Patch.class);
        Find f = finder.getAnnotation(Find.class);
        TypeElement fallbackClass = finder.getEnclosingElement() instanceof ExecutableElement ? (TypeElement)finder.getEnclosingElement().getEnclosingElement() : (TypeElement)finder.getEnclosingElement();
        ClassContainer parent = ClassContainer.findOrFallback(fallbackClass, p, f, opts);
        String name = f.name().isEmpty() ? finder.getSimpleName().toString() : f.name();
        TypeMirror fieldType = ASTUtils.getTypeFromAnnotation(f, Find::type, opts.env);
        String descriptor = fieldType.toString().equals("java.lang.Object") ? null : (fieldType.getKind() != TypeKind.VOID && !fieldType.getKind().isPrimitive() ? String.format("L%s;", ClassContainer.from(f, (Function<Find, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, type(), (Lftbsc/lll/processor/annotations/Find;)Ljava/lang/Class;)(), (String)f.typeFqn(), (String[])f.typeInner(), (ProcessorOptions)opts).data.nameMapped) : ASTUtils.descriptorFromType(fieldType, opts.env));
        return new FieldContainer(parent, name, descriptor, opts);
    }
}

