/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor.containers;

import com.squareup.javapoet.MethodSpec;
import ftbsc.lll.processor.ProcessorOptions;
import ftbsc.lll.processor.annotations.Find;
import ftbsc.lll.processor.annotations.Patch;
import ftbsc.lll.processor.annotations.Target;
import ftbsc.lll.processor.containers.ClassContainer;
import ftbsc.lll.processor.containers.FieldContainer;
import ftbsc.lll.processor.containers.MethodContainer;
import ftbsc.lll.processor.utils.ASTUtils;
import ftbsc.lll.proxies.ProxyType;
import ftbsc.lll.proxies.impl.FieldProxy;
import ftbsc.lll.proxies.impl.MethodProxy;
import ftbsc.lll.proxies.impl.TypeProxy;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class FinderInfo {
    public final TypeElement injectorClass;
    public final VariableElement proxy;
    public final ExecutableElement targetStub;
    public final Target targetAnn;

    public FinderInfo(TypeElement injectorClass, VariableElement proxy, ExecutableElement targetStub, Target targetAnn) {
        this.injectorClass = injectorClass;
        this.proxy = proxy;
        this.targetStub = targetStub;
        this.targetAnn = targetAnn;
    }

    public void appendToMethodSpec(MethodSpec.Builder methodBuilder, boolean local, ProcessorOptions options) {
        Element target;
        ClassContainer parent;
        String nameObf;
        String descriptorObf;
        ProxyType type = ASTUtils.getProxyType(this.proxy);
        if (type == ProxyType.PACKAGE) {
            return;
        }
        Find f = this.proxy.getAnnotation(Find.class);
        if (type == ProxyType.TYPE) {
            ClassContainer clazz = ClassContainer.findOrFallback(this.injectorClass, this.injectorClass.getAnnotation(Patch.class), f, options);
            if (local) {
                methodBuilder.addStatement("$T $L = $T.from($S, 0, $L)", new Object[]{TypeProxy.class, this.proxy.getSimpleName().toString(), TypeProxy.class, clazz.data.nameMapped.replace('/', '.'), clazz.elem == null ? 0 : ASTUtils.mapModifiers(clazz.elem.getModifiers())});
            } else {
                methodBuilder.addStatement("super.$L = $T.from($S, 0, $L)", new Object[]{this.proxy.getSimpleName().toString(), TypeProxy.class, clazz.data.nameMapped.replace('/', '.'), clazz.elem == null ? 0 : ASTUtils.mapModifiers(clazz.elem.getModifiers())});
            }
            return;
        }
        boolean isMethod = type == ProxyType.METHOD;
        String builderName = this.proxy.getSimpleName().toString() + "Builder";
        if (isMethod) {
            MethodContainer mc = MethodContainer.from(this.targetStub, this.targetAnn, f, options);
            descriptorObf = mc.descriptorObf;
            nameObf = mc.data.nameMapped;
            parent = mc.parent;
            target = mc.elem;
        } else {
            FieldContainer fc = FieldContainer.from(this.proxy, options);
            descriptorObf = fc.descriptorObf;
            nameObf = fc.data.nameMapped;
            parent = fc.parent;
            target = fc.elem;
        }
        methodBuilder.addStatement("$T $L = $T.builder($S)", new Object[]{isMethod ? MethodProxy.Builder.class : FieldProxy.Builder.class, builderName, isMethod ? MethodProxy.class : FieldProxy.class, nameObf});
        methodBuilder.addStatement("$L.setParent($S, $L)", new Object[]{builderName, parent.data.nameMapped.replace('/', '.'), parent.elem == null ? 0 : ASTUtils.mapModifiers(parent.elem.getModifiers())});
        methodBuilder.addStatement("$L.setModifiers($L)", new Object[]{builderName, target == null ? 0 : ASTUtils.mapModifiers(target.getModifiers())});
        methodBuilder.addStatement("$L.setDescriptor($S)", new Object[]{builderName, descriptorObf});
        if (local) {
            methodBuilder.addStatement("$T $L = $L.build()", new Object[]{isMethod ? MethodProxy.class : FieldProxy.class, this.proxy.getSimpleName().toString(), builderName});
        } else {
            methodBuilder.addStatement("super.$L = $L.build()", new Object[]{this.proxy.getSimpleName().toString(), builderName});
        }
    }
}

