/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor.containers;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import ftbsc.lll.exceptions.OrphanElementException;
import ftbsc.lll.processor.ProcessorOptions;
import ftbsc.lll.processor.annotations.Injector;
import ftbsc.lll.processor.annotations.Target;
import ftbsc.lll.processor.containers.FinderInfo;
import ftbsc.lll.processor.containers.MethodContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class InjectorInfo {
    public final String name;
    public final ExecutableElement injector;
    public final ExecutableElement targetStub;
    public final String reason;
    public final String outputPackage;
    public final MethodContainer target;
    public final List<FinderInfo> finderParams = new ArrayList<FinderInfo>();

    public InjectorInfo(String name, ExecutableElement injector, ExecutableElement targetStub, Target targetAnn, ProcessorOptions options) {
        this.name = name;
        this.injector = injector;
        this.targetStub = targetStub;
        this.reason = injector.getAnnotation(Injector.class).reason();
        String localPkgOverride = injector.getAnnotation(Injector.class).outputPackage();
        if (!localPkgOverride.equals("[]")) {
            this.outputPackage = localPkgOverride;
        } else if (options.outputPackage != null) {
            this.outputPackage = options.outputPackage;
        } else {
            Element packageElement = injector.getEnclosingElement();
            while (packageElement.getKind() != ElementKind.PACKAGE) {
                packageElement = packageElement.getEnclosingElement();
            }
            this.outputPackage = packageElement.toString();
        }
        this.target = MethodContainer.from(targetStub, targetAnn, null, options);
    }

    public MethodSpec generateInjector(ProcessorOptions options) {
        TypeMirror classNode = options.env.getElementUtils().getTypeElement("org.objectweb.asm.tree.ClassNode").asType();
        TypeMirror methodNode = options.env.getElementUtils().getTypeElement("org.objectweb.asm.tree.MethodNode").asType();
        MethodSpec.Builder injectBuilder = MethodSpec.methodBuilder((String)"inject").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)classNode), (String)"clazz", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)methodNode), (String)"method", (Modifier[])new Modifier[0]).build());
        HashMap<VariableElement, FinderInfo> finderMap = new HashMap<VariableElement, FinderInfo>();
        for (FinderInfo info : this.finderParams) {
            finderMap.put(info.proxy, info);
            info.appendToMethodSpec(injectBuilder, true, options);
        }
        StringBuilder sb = new StringBuilder("super.$L(");
        for (VariableElement variableElement : this.injector.getParameters()) {
            if (variableElement.asType().equals(classNode)) {
                sb.append("clazz,");
                continue;
            }
            if (variableElement.asType().equals(methodNode)) {
                sb.append("method,");
                continue;
            }
            if (finderMap.containsKey(variableElement)) {
                sb.append(variableElement.getSimpleName().toString()).append(",");
                continue;
            }
            throw new OrphanElementException(variableElement);
        }
        injectBuilder.addStatement(sb.deleteCharAt(sb.length() - 1).append(")").toString(), new Object[]{this.injector.getSimpleName()});
        return injectBuilder.build();
    }
}

