/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor.containers;

import ftbsc.lll.exceptions.AmbiguousDefinitionException;
import ftbsc.lll.mapper.data.ClassData;
import ftbsc.lll.mapper.data.MethodData;
import ftbsc.lll.mapper.utils.Mapper;
import ftbsc.lll.mapper.utils.MappingUtils;
import ftbsc.lll.processor.ProcessorOptions;
import ftbsc.lll.processor.annotations.Find;
import ftbsc.lll.processor.annotations.Overridden;
import ftbsc.lll.processor.annotations.Patch;
import ftbsc.lll.processor.annotations.Target;
import ftbsc.lll.processor.containers.ClassContainer;
import ftbsc.lll.processor.utils.ASTUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;

public class MethodContainer {
    public final MethodData data;
    public final String descriptorObf;
    public final ClassContainer parent;
    public final ExecutableElement elem;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MethodContainer(ClassContainer parent, String name, String descriptor, boolean unchecked, boolean strict, boolean bridge, ExecutableElement overriddenStub, ProcessorOptions options) {
        this.parent = parent;
        if (parent.elem == null) {
            if (!unchecked && !strict) throw new AmbiguousDefinitionException("Cannot use name-based lookups for methods of unverifiable classes!");
            this.elem = null;
        } else if (unchecked) {
            this.elem = null;
        } else {
            ExecutableElement tmp = (ExecutableElement)ASTUtils.findMember(parent, name, descriptor, strict, false, options.env);
            this.elem = bridge ? ASTUtils.findSyntheticBridge(tmp, options.env) : tmp;
            name = this.elem.getSimpleName().toString();
            if (strict) {
                descriptor = ASTUtils.descriptorFromExecutableElement(this.elem, options.env);
            }
        }
        boolean[] lookupOutcome = new boolean[]{true};
        MethodData baseData = ASTUtils.getMethodData(parent.data.name, name, descriptor, options.mapper, lookupOutcome);
        if (this.parent.elem != null && (overriddenStub != null || !lookupOutcome[0]) && this.elem == null ^ overriddenStub == null) {
            ExecutableElement top;
            if (overriddenStub != null) {
                Overridden o = overriddenStub.getAnnotation(Overridden.class);
                top = (ExecutableElement)ASTUtils.findMember(ClassContainer.from(o, Overridden::parent, o.parentFqn(), o.parentInner(), options), overriddenStub.getSimpleName().toString(), o.strict() ? ASTUtils.descriptorFromExecutableElement(overriddenStub, options.env) : null, o.strict(), false, options.env);
            } else {
                top = ASTUtils.findOverloadedMethod(this.parent.elem, this.elem, options.env);
            }
            ClassData topParentData = ASTUtils.getClassData(ASTUtils.internalNameFromType(top.getEnclosingElement().asType(), options.env), options.mapper);
            MethodData topData = ASTUtils.getMethodData(topParentData.name, top.getSimpleName().toString(), ASTUtils.descriptorFromExecutableElement(top, options.env), options.mapper, null);
            this.data = new MethodData(parent.data, baseData.signature.name, topData.nameMapped, baseData.signature.descriptor);
        } else {
            this.data = baseData;
        }
        if (strict) {
            descriptor = this.data.signature.descriptor;
        }
        this.descriptorObf = options.mapper == null ? descriptor : MappingUtils.mapMethodDescriptor((String)descriptor, (Mapper)options.mapper, (boolean)false);
    }

    public static MethodContainer from(ExecutableElement stub, Target t, Find f, ProcessorOptions opts) {
        Patch p = stub.getEnclosingElement().getAnnotation(Patch.class);
        ClassContainer parent = ClassContainer.findOrFallback((TypeElement)stub.getEnclosingElement(), p, f, opts);
        String name = !t.methodName().isEmpty() ? t.methodName() : stub.getSimpleName().toString();
        String descriptor = ASTUtils.descriptorFromExecutableElement(stub, opts.env);
        return new MethodContainer(parent, name, descriptor, t.unchecked(), t.strict(), t.bridge(), MethodContainer.findOverriddenStub(stub), opts);
    }

    public static ExecutableElement findOverriddenStub(ExecutableElement stub) {
        List elements = stub.getEnclosingElement().getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).filter(e -> {
            if (e.getParameters().size() != stub.getParameters().size()) {
                return false;
            }
            Overridden ann = e.getAnnotation(Overridden.class);
            if (ann == null) {
                return false;
            }
            CharSequence nameLookingFor = ann.by().isEmpty() ? stub.getSimpleName() : ann.by();
            return stub.getSimpleName().equals(nameLookingFor);
        }).collect(Collectors.toList());
        switch (elements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ExecutableElement)elements.get(0);
            }
        }
        throw new AmbiguousDefinitionException(String.format("Found multiple @Overridden methods for stub %s.%s!", ((QualifiedNameable)stub.getEnclosingElement()).getQualifiedName().toString(), stub.getSimpleName().toString()));
    }
}

