/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor.utils;

import ftbsc.lll.exceptions.AmbiguousDefinitionException;
import ftbsc.lll.exceptions.InvalidClassNameException;
import ftbsc.lll.exceptions.MappingNotFoundException;
import ftbsc.lll.exceptions.NotAProxyException;
import ftbsc.lll.exceptions.TargetNotFoundException;
import ftbsc.lll.mapper.data.ClassData;
import ftbsc.lll.mapper.data.FieldData;
import ftbsc.lll.mapper.data.MethodData;
import ftbsc.lll.mapper.utils.Mapper;
import ftbsc.lll.processor.annotations.Target;
import ftbsc.lll.processor.containers.ClassContainer;
import ftbsc.lll.proxies.ProxyType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

public class ASTUtils {
    private static final Pattern NUMERIC = Pattern.compile("^[0-9]+$");

    public static <T extends Element> List<T> findAnnotatedEnclosedElements(Element parent, Class<? extends Annotation> ann) {
        return parent.getEnclosedElements().stream().filter(e -> e.getAnnotationsByType(ann).length != 0).map(e -> e).collect(Collectors.toList());
    }

    public static int mapModifier(Modifier m) {
        switch (m) {
            case PUBLIC: {
                return 1;
            }
            case PROTECTED: {
                return 4;
            }
            case PRIVATE: {
                return 2;
            }
            case ABSTRACT: {
                return 1024;
            }
            case STATIC: {
                return 8;
            }
            case FINAL: {
                return 16;
            }
            case TRANSIENT: {
                return 128;
            }
            case VOLATILE: {
                return 64;
            }
            case SYNCHRONIZED: {
                return 32;
            }
            case NATIVE: {
                return 256;
            }
            case STRICTFP: {
                return 2048;
            }
        }
        return 0;
    }

    public static int mapModifiers(Collection<Modifier> modifiers) {
        int i = 0;
        for (Modifier m : modifiers) {
            i |= ASTUtils.mapModifier(m);
        }
        return i;
    }

    public static <T extends Annotation> TypeMirror getTypeFromAnnotation(T ann, Function<T, Class<?>> classFunction, ProcessingEnvironment env) {
        try {
            String fqn = classFunction.apply(ann).getCanonicalName();
            if (fqn == null) {
                fqn = "";
            }
            return env.getElementUtils().getTypeElement(fqn).asType();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }

    public static String internalNameFromType(TypeMirror type, ProcessingEnvironment env) {
        Element elem = env.getTypeUtils().asElement(env.getTypeUtils().erasure(type));
        StringBuilder fqnBuilder = new StringBuilder();
        while (elem.getEnclosingElement() != null && elem.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            fqnBuilder.insert(0, elem.getSimpleName().toString()).insert(0, "$");
            elem = elem.getEnclosingElement();
        }
        return fqnBuilder.insert(0, env.getTypeUtils().erasure(elem.asType()).toString()).toString().replace('.', '/');
    }

    public static String descriptorFromType(TypeMirror t, ProcessingEnvironment env) {
        t = env.getTypeUtils().erasure(t);
        StringBuilder desc = new StringBuilder();
        while (t.getKind() == TypeKind.ARRAY) {
            desc.append("[");
            t = ((ArrayType)t).getComponentType();
        }
        if (t.getKind() == TypeKind.TYPEVAR) {
            t = ((TypeVariable)t).getUpperBound();
        }
        if (t.getKind() == TypeKind.DECLARED) {
            desc.append("L").append(ASTUtils.internalNameFromType(t, env)).append(";");
        } else {
            switch (t.getKind()) {
                case BOOLEAN: {
                    desc.append("Z");
                    break;
                }
                case CHAR: {
                    desc.append("C");
                    break;
                }
                case BYTE: {
                    desc.append("B");
                    break;
                }
                case SHORT: {
                    desc.append("S");
                    break;
                }
                case INT: {
                    desc.append("I");
                    break;
                }
                case FLOAT: {
                    desc.append("F");
                    break;
                }
                case LONG: {
                    desc.append("J");
                    break;
                }
                case DOUBLE: {
                    desc.append("D");
                    break;
                }
                case VOID: {
                    desc.append("V");
                }
            }
        }
        return desc.toString();
    }

    public static String descriptorFromExecutableElement(ExecutableElement m, ProcessingEnvironment env) {
        StringBuilder methodSignature = new StringBuilder();
        methodSignature.append("(");
        m.getParameters().forEach(p -> methodSignature.append(ASTUtils.descriptorFromType(p.asType(), env)));
        methodSignature.append(")");
        methodSignature.append(ASTUtils.descriptorFromType(m.getReturnType(), env));
        return methodSignature.toString();
    }

    public static ClassData getClassData(String name, Mapper mapper) {
        try {
            name = name.replace('.', '/');
            if (mapper != null) {
                return mapper.getClassData(name);
            }
        }
        catch (MappingNotFoundException mappingNotFoundException) {
            // empty catch block
        }
        return new ClassData(name, name);
    }

    public static MethodData getMethodData(String parent, String name, String descriptor, Mapper mapper, boolean[] outcome) {
        block3: {
            try {
                parent = parent.replace('.', '/');
                if (mapper != null) {
                    return mapper.getMethodData(parent, name, descriptor);
                }
            }
            catch (MappingNotFoundException ex) {
                if (outcome == null || outcome.length < 1) break block3;
                outcome[0] = false;
            }
        }
        return new MethodData(ASTUtils.getClassData(name, mapper), name, name, descriptor);
    }

    public static FieldData getFieldData(String parent, String name, Mapper mapper) {
        try {
            name = name.replace('.', '/');
            if (mapper != null) {
                return mapper.getFieldData(parent, name);
            }
        }
        catch (MappingNotFoundException mappingNotFoundException) {
            // empty catch block
        }
        return new FieldData(ASTUtils.getClassData(name, mapper), name, name);
    }

    public static Element findMember(ClassContainer parent, String name, String descr, boolean strict, boolean field, ProcessingEnvironment env) {
        if (parent.elem == null) {
            throw new TargetNotFoundException("parent class", parent.data.name);
        }
        List candidates = parent.elem.getEnclosedElements().stream().filter(e -> field && e instanceof VariableElement || e instanceof ExecutableElement).filter(e -> e.getSimpleName().contentEquals(name)).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            throw new TargetNotFoundException(field ? "field" : "method", name, parent.data.name);
        }
        if (!(candidates.size() != 1 || strict && descr != null)) {
            return (Element)candidates.get(0);
        }
        if (descr == null) {
            throw new AmbiguousDefinitionException(String.format("Found %d members named %s in class %s!", candidates.size(), name, parent.data.name));
        }
        if (field) {
            if (!ASTUtils.descriptorFromType(((Element)candidates.get(0)).asType(), env).equals(descr)) {
                throw new TargetNotFoundException("field", String.format("%s with descriptor %s", name, descr), parent.data.name);
            }
        } else {
            candidates = candidates.stream().map(e -> (ExecutableElement)e).filter(strict ? c -> descr.equals(ASTUtils.descriptorFromExecutableElement(c, env)) : c -> descr.split("\\)")[0].equalsIgnoreCase(ASTUtils.descriptorFromExecutableElement(c, env).split("\\)")[0])).collect(Collectors.toList());
        }
        if (candidates.isEmpty()) {
            throw new TargetNotFoundException("method", String.format("%s %s", name, descr), parent.data.name);
        }
        if (candidates.size() > 1) {
            throw new AmbiguousDefinitionException(String.format("Found %d methods named %s in class %s!", candidates.size(), name, parent.data.name));
        }
        return (Element)candidates.get(0);
    }

    public static ExecutableElement findOverloadedMethod(TypeElement context, ExecutableElement method, ProcessingEnvironment env) {
        for (Element element : context.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !env.getElementUtils().overrides(method, (ExecutableElement)element, (TypeElement)method.getEnclosingElement())) continue;
            method = (ExecutableElement)element;
            break;
        }
        ArrayList<TypeElement> potentialDeclarers = new ArrayList<TypeElement>();
        if (context.getSuperclass().getKind() != TypeKind.NONE) {
            potentialDeclarers.add((TypeElement)env.getTypeUtils().asElement(context.getSuperclass()));
        }
        for (TypeMirror typeMirror : context.getInterfaces()) {
            if (typeMirror.getKind() == TypeKind.NONE) continue;
            potentialDeclarers.add((TypeElement)env.getTypeUtils().asElement(typeMirror));
        }
        potentialDeclarers.removeIf(d -> d.getQualifiedName().contentEquals("java.lang.Object"));
        for (TypeElement typeElement : potentialDeclarers) {
            ExecutableElement found = ASTUtils.findOverloadedMethod(typeElement, method, env);
            if (found.equals(method)) continue;
            method = found;
            break;
        }
        return method;
    }

    public static ExecutableElement findSyntheticBridge(ExecutableElement method, ProcessingEnvironment env) throws TargetNotFoundException {
        TypeElement parent = (TypeElement)method.getEnclosingElement();
        ExecutableElement overriding = ASTUtils.findOverloadedMethod(parent, method, env);
        if (ASTUtils.descriptorFromExecutableElement(overriding, env).equals(ASTUtils.descriptorFromExecutableElement(method, env))) {
            throw new TargetNotFoundException("bridge method for", overriding.getSimpleName().toString(), parent.getQualifiedName().toString());
        }
        return overriding;
    }

    public static ProxyType getProxyType(VariableElement v) {
        String returnTypeFQN;
        switch (returnTypeFQN = v.asType().toString()) {
            case "ftbsc.lll.proxies.impl.FieldProxy": {
                return ProxyType.FIELD;
            }
            case "ftbsc.lll.proxies.impl.MethodProxy": {
                return ProxyType.METHOD;
            }
            case "ftbsc.lll.proxies.impl.TypeProxy": {
                return ProxyType.TYPE;
            }
            case "ftbsc.lll.proxies.impl.PackageProxy": {
                return ProxyType.PACKAGE;
            }
        }
        throw new NotAProxyException(v.getEnclosingElement().getSimpleName().toString(), v.getSimpleName().toString());
    }

    public static boolean shouldValidate(String name) throws InvalidClassNameException {
        if (SourceVersion.isIdentifier(name) && !SourceVersion.isKeyword(name)) {
            return true;
        }
        if (NUMERIC.matcher(name).matches()) {
            return false;
        }
        throw new InvalidClassNameException(name);
    }

    public static Element matchTarget(TypeElement parent, ExecutableElement target, Target targetAnn, List<ExecutableElement> injectorCandidates, List<VariableElement> finderCandidates, ProcessingEnvironment processingEnv) {
        injectorCandidates = injectorCandidates.stream().filter(i -> i.getSimpleName().contentEquals(targetAnn.of())).collect(Collectors.toList());
        if (!(finderCandidates = finderCandidates.stream().filter(i -> i.getSimpleName().contentEquals(targetAnn.of())).collect(Collectors.toList())).isEmpty() && !injectorCandidates.isEmpty()) {
            throw new AmbiguousDefinitionException(String.format("Target specified user %s, but name was used by both a finder and injector.", targetAnn.of()));
        }
        if (finderCandidates.isEmpty() && injectorCandidates.isEmpty()) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Found orphan @Target annotation on method %s.%s pointing at method %s, it will be ignored!", parent.getSimpleName().toString(), target.getSimpleName().toString(), targetAnn.of()));
            return null;
        }
        if (finderCandidates.isEmpty() && injectorCandidates.size() != 1) {
            throw new AmbiguousDefinitionException(String.format("Found multiple candidate injectors for target %s::%s!", parent.getSimpleName(), target.getSimpleName()));
        }
        if (injectorCandidates.isEmpty() && finderCandidates.size() != 1) {
            throw new AmbiguousDefinitionException(String.format("Found multiple candidate finders for target %s::%s!", parent.getSimpleName(), target.getSimpleName()));
        }
        if (injectorCandidates.size() == 1) {
            return injectorCandidates.get(0);
        }
        return finderCandidates.get(0);
    }
}

