/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.processor.utils;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class JavaPoetUtils {
    public static MethodSpec buildStringReturnMethod(String name, String returnString) {
        return MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $S", new Object[]{returnString}).build();
    }

    public static HashSet<MethodSpec> generateDummies(TypeElement clazz) {
        HashSet<MethodSpec> specs = new HashSet<MethodSpec>();
        clazz.getEnclosedElements().stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).forEach(e -> {
            if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                specs.add(MethodSpec.overriding((ExecutableElement)e).addStatement("throw new $T($S)", new Object[]{RuntimeException.class, "This is a stub and should not have been called"}).build());
            }
        });
        return specs;
    }

    public static String generateRealClassName(TypeElement cl) {
        StringBuilder name = new StringBuilder(cl.getSimpleName().toString());
        while (cl.getEnclosingElement() instanceof TypeElement) {
            cl = (TypeElement)cl.getEnclosingElement();
            name.insert(0, '$');
            name.insert(0, cl.getSimpleName());
        }
        return name.toString();
    }

    public static String writeClass(Filer filer, String pkg, String name, TypeSpec spec) {
        String fqn = String.format("%s.%s", pkg, name);
        JavaFile javaFile = JavaFile.builder((String)pkg, (TypeSpec)spec).build();
        try (PrintWriter out = new PrintWriter(filer.createSourceFile(fqn, new Element[0]).openWriter());){
            javaFile.writeTo((Appendable)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return fqn;
    }
}

