/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.gradle;

import ftbsc.lll.gradle.util.FakeMixinConfiguration;
import ftbsc.lll.gradle.util.MappingsConfiguration;
import javax.inject.Inject;
import lombok.Generated;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;

public abstract class LilleroGradleExtension {
    private final Project project;
    private final Property<Boolean> registerRepo;
    private final Property<Boolean> auto;
    private final Property<String> coreVersion;
    private final Property<String> processorVersion;
    private final Property<String> mixinVersion;
    private final Property<String> loaderVersion;
    private final Property<Boolean> shadow;
    private final Property<String> fakeMixinFQN;
    private final Property<String> outputPackage;
    private final RegularFileProperty mappings;
    private final Property<String> mappingsNamespaceFrom;
    private final Property<String> mappingsNamespaceTo;
    private final Property<Boolean> anonymousClassWarning;
    private final Property<Boolean> manualClassWarning;
    private final Property<Boolean> obfuscateInjectorMetadata;
    private final Property<Boolean> noServiceProvider;
    private MappingsConfiguration mapCfg = null;
    private FakeMixinConfiguration fmCfg = null;

    @Inject
    public LilleroGradleExtension(ObjectFactory factory, Project project) {
        this.project = project;
        this.registerRepo = factory.property(Boolean.class).convention((Object)true);
        this.auto = factory.property(Boolean.class).convention((Object)true);
        this.coreVersion = factory.property(String.class).convention((Object)"+");
        this.mixinVersion = factory.property(String.class).convention((Object)"+");
        this.loaderVersion = factory.property(String.class).convention((Object)"+");
        this.processorVersion = factory.property(String.class).convention((Object)"+");
        this.shadow = factory.property(Boolean.class).convention((Object)false);
        this.fakeMixinFQN = factory.property(String.class);
        this.outputPackage = factory.property(String.class);
        this.mappings = factory.fileProperty();
        this.mappingsNamespaceFrom = factory.property(String.class);
        this.mappingsNamespaceTo = factory.property(String.class);
        this.anonymousClassWarning = factory.property(Boolean.class).convention((Object)true);
        this.manualClassWarning = factory.property(Boolean.class).convention((Object)true);
        this.obfuscateInjectorMetadata = factory.property(Boolean.class).convention((Object)true);
        this.noServiceProvider = factory.property(Boolean.class).convention((Object)false);
    }

    public MappingsConfiguration getMappingsConfiguration() {
        return this.mapCfg != null ? this.mapCfg : (this.mapCfg = new MappingsConfiguration(this.project, this));
    }

    public FakeMixinConfiguration getFakeMixinConfiguration() {
        return this.fmCfg != null ? this.fmCfg : (this.fmCfg = new FakeMixinConfiguration(this));
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public Property<Boolean> getRegisterRepo() {
        return this.registerRepo;
    }

    @Generated
    public Property<Boolean> getAuto() {
        return this.auto;
    }

    @Generated
    public Property<String> getCoreVersion() {
        return this.coreVersion;
    }

    @Generated
    public Property<String> getProcessorVersion() {
        return this.processorVersion;
    }

    @Generated
    public Property<String> getMixinVersion() {
        return this.mixinVersion;
    }

    @Generated
    public Property<String> getLoaderVersion() {
        return this.loaderVersion;
    }

    @Generated
    public Property<Boolean> getShadow() {
        return this.shadow;
    }

    @Generated
    public Property<String> getFakeMixinFQN() {
        return this.fakeMixinFQN;
    }

    @Generated
    public Property<String> getOutputPackage() {
        return this.outputPackage;
    }

    @Generated
    public RegularFileProperty getMappings() {
        return this.mappings;
    }

    @Generated
    public Property<String> getMappingsNamespaceFrom() {
        return this.mappingsNamespaceFrom;
    }

    @Generated
    public Property<String> getMappingsNamespaceTo() {
        return this.mappingsNamespaceTo;
    }

    @Generated
    public Property<Boolean> getAnonymousClassWarning() {
        return this.anonymousClassWarning;
    }

    @Generated
    public Property<Boolean> getManualClassWarning() {
        return this.manualClassWarning;
    }

    @Generated
    public Property<Boolean> getObfuscateInjectorMetadata() {
        return this.obfuscateInjectorMetadata;
    }

    @Generated
    public Property<Boolean> getNoServiceProvider() {
        return this.noServiceProvider;
    }

    @Generated
    public MappingsConfiguration getMapCfg() {
        return this.mapCfg;
    }

    @Generated
    public FakeMixinConfiguration getFmCfg() {
        return this.fmCfg;
    }
}

