/*
 * Decompiled with CFR 0.152.
 */
package ftbsc.lll.gradle.util;

import ftbsc.lll.gradle.LilleroGradleExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.RegularFile;

public class MappingsConfiguration {
    private final Project project;
    private File mappings = null;
    private String namespaceFrom = null;
    private String namespaceTo = null;
    private boolean override = false;
    private Task taskIgnore = null;

    public MappingsConfiguration(Project project, LilleroGradleExtension extension) {
        this.project = project;
        if (extension.getMappings().isPresent()) {
            RegularFile file = (RegularFile)extension.getMappings().getOrNull();
            this.mappings = file != null ? file.getAsFile() : null;
            this.namespaceFrom = (String)extension.getMappingsNamespaceFrom().getOrNull();
            this.namespaceTo = (String)extension.getMappingsNamespaceFrom().getOrNull();
            this.override = true;
        } else if (this.project.getPlugins().hasPlugin("fabric-loom")) {
            this.mappings = MappingsConfiguration.extract(project);
            this.namespaceFrom = "named";
            this.namespaceTo = "intermediary";
            this.taskIgnore = (Task)project.getTasks().findByName("runClient");
        }
    }

    private static File extract(Project project) {
        Configuration mappingsConfig = (Configuration)project.getConfigurations().findByName("mappings");
        if (mappingsConfig != null) {
            File extractedTiny;
            block22: {
                File mappingsJar = mappingsConfig.getSingleFile();
                extractedTiny = MappingsConfiguration.getMappingFile(project, mappingsConfig);
                try (ZipFile zip = new ZipFile(mappingsJar);){
                    long fileCrc;
                    ZipEntry tinyEntry = zip.getEntry("mappings/mappings.tiny");
                    if (tinyEntry == null) {
                        throw new RuntimeException("Bad mappings jar!");
                    }
                    long zipCrc = tinyEntry.getCrc();
                    boolean needsExtract = true;
                    if (extractedTiny.exists() && zipCrc == (fileCrc = MappingsConfiguration.computeCRC32(extractedTiny))) {
                        needsExtract = false;
                    }
                    if (!needsExtract) break block22;
                    try (InputStream in = zip.getInputStream(tinyEntry);
                         FileOutputStream out = new FileOutputStream(extractedTiny);){
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = in.read(buffer)) > 0) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                    }
                }
            }
            return extractedTiny;
        }
        throw new RuntimeException("Loom applied but no mappings found!");
    }

    private static File getMappingFile(Project project, Configuration mappingsConfig) {
        String versionSuffix = "unknown";
        Set artifacts = mappingsConfig.getResolvedConfiguration().getResolvedArtifacts();
        for (ResolvedArtifact artifact : artifacts) {
            if (!artifact.getName().equalsIgnoreCase("yarn")) continue;
            versionSuffix = artifact.getModuleVersion().getId().getVersion();
            break;
        }
        File gradleDir = new File(project.getGradle().getGradleUserHomeDir(), "lillero/yarn");
        gradleDir.mkdirs();
        return new File(gradleDir, "mappings-" + versionSuffix + ".tiny");
    }

    private static long computeCRC32(File file) throws IOException {
        CRC32 crc = new CRC32();
        try (FileInputStream in = new FileInputStream(file);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                crc.update(buffer, 0, len);
            }
        }
        return crc.getValue();
    }

    public void appendCompilerArgs(List<String> compilerArgs) {
        if (this.taskIgnore != null && this.project.getGradle().getTaskGraph().hasTask(this.taskIgnore)) {
            return;
        }
        if (this.mappings != null) {
            compilerArgs.add("-AmappingsFile=" + this.mappings.getAbsolutePath());
            if (this.namespaceFrom != null && this.namespaceTo != null) {
                compilerArgs.add("-AmappingsNamespaceFrom=" + this.namespaceFrom);
                compilerArgs.add("-AmappingsNamespaceTo=" + this.namespaceTo);
            }
        }
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public File getMappings() {
        return this.mappings;
    }

    @Generated
    public String getNamespaceFrom() {
        return this.namespaceFrom;
    }

    @Generated
    public String getNamespaceTo() {
        return this.namespaceTo;
    }

    @Generated
    public boolean isOverride() {
        return this.override;
    }

    @Generated
    public Task getTaskIgnore() {
        return this.taskIgnore;
    }
}

